/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.wand;

import com.mojang.logging.LogUtils;
import net.minecraft.class_243;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.animation.UnilateralPortalState;
import qouteall.q_misc_util.my_util.Circle;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.Plane;
import qouteall.q_misc_util.my_util.Sphere;

public enum PortalCorner {
    LEFT_BOTTOM,
    LEFT_TOP,
    RIGHT_BOTTOM,
    RIGHT_TOP;

    private static final Logger LOGGER;

    public int getXSign() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 1 -> -1;
            case 2, 3 -> 1;
        };
    }

    public int getYSign() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0, 2 -> -1;
            case 1, 3 -> 1;
        };
    }

    public class_243 getOffset(Portal portal) {
        return portal.getAxisW().method_1021(portal.getWidth() / 2.0 * (double)this.getXSign()).method_1019(portal.getAxisH().method_1021(portal.getHeight() / 2.0 * (double)this.getYSign()));
    }

    public class_243 getPos(Portal portal) {
        return portal.getOriginPos().method_1019(this.getOffset(portal));
    }

    public class_243 getOffset(UnilateralPortalState ups) {
        return ups.getAxisW().method_1021(ups.width() / 2.0 * (double)this.getXSign()).method_1019(ups.getAxisH().method_1021(ups.height() / 2.0 * (double)this.getYSign()));
    }

    public class_243 getPos(UnilateralPortalState ups) {
        return ups.position().method_1019(this.getOffset(ups));
    }

    public static UnilateralPortalState performDragWithNoLockedCorner(UnilateralPortalState originalState, PortalCorner freeCorner, class_243 freePos) {
        class_243 offset = freeCorner.getOffset(originalState);
        class_243 newPos = freePos.method_1020(offset);
        return new UnilateralPortalState.Builder().from(originalState).position(newPos).build();
    }

    @Nullable
    public static UnilateralPortalState performDragWith1LockedCorner(UnilateralPortalState originalState, PortalCorner lockedCorner, class_243 lockedPos, PortalCorner freeCorner, class_243 freePos) {
        class_243 originalFreeCornerPos = freeCorner.getPos(originalState);
        class_243 originalOffset = originalFreeCornerPos.method_1020(lockedPos);
        class_243 newOffset = freePos.method_1020(lockedPos);
        if (originalOffset.method_1027() < 0.001 || newOffset.method_1027() < 0.001) {
            return null;
        }
        double dot = originalOffset.method_1029().method_1026(newOffset.method_1029());
        DQuaternion rotation = Math.abs(dot) > 0.99999 ? null : DQuaternion.getRotationBetween(originalOffset, newOffset);
        double scaling = newOffset.method_1033() / originalOffset.method_1033();
        class_243 offset = originalState.position().method_1020(lockedPos).method_1021(scaling);
        if (rotation != null) {
            offset = rotation.rotate(offset);
        }
        class_243 newOrigin = lockedPos.method_1019(offset);
        DQuaternion newOrientation = rotation == null ? originalState.orientation() : rotation.hamiltonProduct(originalState.orientation());
        double newWidth = originalState.width() * scaling;
        double newHeight = originalState.height() * scaling;
        return new UnilateralPortalState.Builder().from(originalState).position(newOrigin).orientation(newOrientation).width(newWidth).height(newHeight).build();
    }

    public static DraggingConstraint getDraggingConstraintWith2LockedCorners(PortalCorner lockedCorner1, class_243 lockedPos1, PortalCorner lockedCorner2, class_243 lockedPos2, PortalCorner freeCorner) {
        int corner1XSign = lockedCorner1.getXSign();
        int corner1YSign = lockedCorner1.getYSign();
        int corner2XSign = lockedCorner2.getXSign();
        int corner2YSign = lockedCorner2.getYSign();
        int freeCornerXSign = freeCorner.getXSign();
        int freeCornerYSign = freeCorner.getYSign();
        if (corner1XSign == corner2XSign || corner1YSign == corner2YSign) {
            if (freeCornerXSign == corner1XSign || freeCornerYSign == corner1YSign) {
                class_243 planeNormal = lockedPos2.method_1020(lockedPos1);
                Plane plane = new Plane(lockedPos1, planeNormal);
                return new DraggingConstraint(plane, null);
            }
            class_243 planeNormal = lockedPos1.method_1020(lockedPos2);
            Plane plane = new Plane(lockedPos2, planeNormal);
            return new DraggingConstraint(plane, null);
        }
        class_243 center = lockedPos1.method_1019(lockedPos2).method_1021(0.5);
        double radius = lockedPos1.method_1022(lockedPos2) * 0.5;
        return new DraggingConstraint(null, new Sphere(center, radius));
    }

    @Nullable
    public static UnilateralPortalState performDragWith2LockedCorners(UnilateralPortalState originalState, PortalCorner lockedCorner1, class_243 lockedPos1, PortalCorner lockedCorner2, class_243 lockedPos2, PortalCorner freeCorner, class_243 freePos) {
        DraggingConstraint constraint = PortalCorner.getDraggingConstraintWith2LockedCorners(lockedCorner1, lockedPos1, lockedCorner2, lockedPos2, freeCorner);
        class_243 freePosLimited = constraint.constrain(freePos);
        if (freePosLimited == null) {
            return null;
        }
        class_243[][] vertices = new class_243[2][2];
        int corner1XSign = lockedCorner1.getXSign();
        int corner1YSign = lockedCorner1.getYSign();
        int corner2XSign = lockedCorner2.getXSign();
        int corner2YSign = lockedCorner2.getYSign();
        int freeCornerXSign = freeCorner.getXSign();
        int freeCornerYSign = freeCorner.getYSign();
        vertices[corner1XSign == -1 ? 0 : 1][corner1YSign == -1 ? 0 : 1] = lockedPos1;
        vertices[corner2XSign == -1 ? 0 : 1][corner2YSign == -1 ? 0 : 1] = lockedPos2;
        vertices[freeCornerXSign == -1 ? 0 : 1][freeCornerYSign == -1 ? 0 : 1] = freePosLimited;
        for (int cx = 0; cx <= 1; ++cx) {
            for (int cy = 0; cy <= 1; ++cy) {
                if (vertices[cx][cy] != null) continue;
                class_243 sideVertex1 = vertices[1 - cx][cy];
                class_243 sideVertex2 = vertices[cx][1 - cy];
                class_243 diagonalVertex = vertices[1 - cx][1 - cy];
                class_243 v1 = sideVertex1.method_1020(diagonalVertex);
                class_243 v2 = sideVertex2.method_1020(diagonalVertex);
                vertices[cx][cy] = diagonalVertex.method_1019(v1).method_1019(v2);
            }
        }
        class_243 horizontalAxis = vertices[1][0].method_1020(vertices[0][0]);
        class_243 verticalAxis = vertices[0][1].method_1020(vertices[0][0]);
        class_243 axisW = horizontalAxis.method_1029();
        class_243 axisH = verticalAxis.method_1029();
        class_243 normal = axisW.method_1036(axisH);
        if (Math.abs(axisW.method_1026(axisH)) > 0.01) {
            LOGGER.error("The dragged portal vertices are ill-formed");
            return null;
        }
        DQuaternion orientation = DQuaternion.matrixToQuaternion(axisW, axisH, normal);
        return new UnilateralPortalState.Builder().dimension(originalState.dimension()).position(vertices[0][0].method_1019(vertices[1][1]).method_1021(0.5)).orientation(orientation).width(horizontalAxis.method_1033()).height(verticalAxis.method_1033()).build();
    }

    static {
        LOGGER = LogUtils.getLogger();
    }

    public record DraggingConstraint(@Nullable Plane plane, @Nullable Sphere sphere) {
        @Nullable
        public class_243 constrain(class_243 pos) {
            if (this.sphere != null) {
                if (this.plane != null) {
                    Circle circle = this.sphere.getIntersectionWithPlane(this.plane);
                    if (circle == null) {
                        return null;
                    }
                    return circle.projectToCircle(pos);
                }
                return this.sphere.projectToSphere(pos);
            }
            if (this.plane != null) {
                return this.plane.getProjection(pos);
            }
            return pos;
        }
    }
}

